import React from 'react';
import { DashboardCore } from '@splunk/dashboard-core';
import { DashboardContextProvider } from '@splunk/dashboard-context';
import EnterprisePreset from '@splunk/dashboard-presets/EnterprisePreset';
import SplunkThemeProvider from '@splunk/themes/SplunkThemeProvider';

//import definition from dashboard studio
import definition from './definition.json';

//import custom visualization
import CustomTable from './customTable';

const themeToVariant = {
    enterprise: { colorScheme: 'light', family: 'enterprise' },
    enterpriseDark: { colorScheme: 'dark', family: 'enterprise' },
    prisma: { colorScheme: 'dark', family: 'prisma' },
};


// use DashboardCore to render a simple dashboard
const customPreset = {
    ...EnterprisePreset,
    visualizations: {
        ...EnterprisePreset.visualizations,
        'splunk.CustomTable': CustomTable
    },
};

export default () => (
    <SplunkThemeProvider {...themeToVariant.prisma}>
        <DashboardContextProvider preset={customPreset}>
            <DashboardCore
                width="100%"
                height="100%"
                definition={definition}
            />
        </DashboardContextProvider>
    </SplunkThemeProvider>
);